using System;
using System.Collections;

namespace IndianHealthService.BMXNet.Tools.SchemaBuilder
{
	/// <summary>
	/// Implements collection of BMXSchemaField objects
	/// </summary>
	[Serializable]
	internal class BMXSchemaFields: IEnumerable
	{
		private Hashtable m_SchemaFieldList;

		internal BMXSchemaFields()
		{
			m_SchemaFieldList = new Hashtable();
		}

		public void AddSchemaField(BMXSchemaField SchemaField)
		{
			m_SchemaFieldList.Add(SchemaField.Key, SchemaField);
		}

		public void RemoveSchemaField(int Key)
		{
			m_SchemaFieldList.Remove(Key);
		}

		public int SchemaFieldCount
		{
			get
			{
				return m_SchemaFieldList.Count;
			}
		}

		public void ClearAllSchemaFields()
		{
			m_SchemaFieldList.Clear();
		}

		public IEnumerator GetEnumerator()
		{
			return m_SchemaFieldList.GetEnumerator();
		}

		public BMXSchemaField GetSchemaField(int Key)
		{
			BMXSchemaField c = (BMXSchemaField) m_SchemaFieldList[Key];
			return c;
		}

		/// <summary>
		/// Exposes the BMXSchemaFields internal Hashtable
		/// </summary>
		public Hashtable SchemaFieldTable
		{
			get
			{
				return this.m_SchemaFieldList;
			}
		}


	}
}
